/**
 * this class save information about which available service can perform 
 * the action in a particular target state and particular composition state
 */
package gui.menus.file.export;

import gui.GenericLoader;
import gui.MainFrame;
import gui.XML.saveToXML;
import java.io.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.JMenuItem;
/**
 * @author Andrea
 *
 */
public class SaveRelationItem extends JMenuItem
{
	private static final long serialVersionUID = 1L;
	final JFileChooser fc;

	public SaveRelationItem()
	{
		super();
		String[] extensions = {"xml"};
		FileNameExtensionFilter filter = new FileNameExtensionFilter(".xml",extensions);
		fc =new JFileChooser();
		fc.setFileFilter(filter);
		init();
	}
	
	void init()
	{
		this.setText("Composition informations as xml...");
		this.setToolTipText("Saves information for each Target State, Composition State and Action, which ones among Availale Services can perform it");
		
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				/**
				 * this part is responsible for saving the file.
				 */
				fc.setSelectedFile(new File("composition"));
				int action = fc.showSaveDialog(MainFrame.getInstance());
				if(action == JFileChooser.APPROVE_OPTION)
				{
					String fileName = fc.getSelectedFile().getPath();
					File toSave = new File(fc.getSelectedFile().getPath()+".xml");
					boolean writeFile = true;
					boolean wantsStylesheet = true;
					/**
					 * in the following: if file already exists, then appears a prompt asking
					 * if you want to replace it. If so, the program continues,
					 * otherwise writeFile will became FALSE and the program terminates without doing anything.
					 */
					if(toSave.exists())
					{
						if(JOptionPane.showConfirmDialog(null, "A file with the specified name already exists.\nDo you want to replace it?", "Specified file already exists", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE)!=JOptionPane.YES_OPTION)
						{
							writeFile = false;
						}
						else
						{
							toSave.delete();
						}
					}
					try
					{
						if(writeFile)
						{
							/**
							 * in the following: you decide if export also the style-sheet for 
							 * for the XML file.
							 */
							int wfs= JOptionPane.showConfirmDialog(null, "Would you like to export the default stylesheet\nfor this file?", "Question", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
							if(wfs==JOptionPane.NO_OPTION)
							{
								wantsStylesheet = false;
							}
							
							/**
							 * here the file will be saved
							 */
							saveToXML.saveCompositionXML(GenericLoader.getCompositionDataToExport(), fileName, wantsStylesheet);
							JOptionPane.showMessageDialog(MainFrame.getInstance(), "File saved correctly", "Success", JOptionPane.INFORMATION_MESSAGE);
						}
					}
					catch(IOException ex)
					{
						JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
					}
					catch(Exception exc)
					{
						JOptionPane.showMessageDialog(null, exc.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
					}
				}
			}
		});
	}
}

